#include <memory>

#include "rclcpp/rclcpp.hpp"
#include "std_msgs/msg/string.hpp"
#include "sensor_msgs/msg/image.hpp"
class MinimalSubscriber : public rclcpp::Node
{
public:
  MinimalSubscriber()
  : Node("minimal_subscriber")
  {
    auto topic_callback =
      [this](sensor_msgs::msg::Image::UniquePtr msg) -> void {
        int total = 0;
        for(auto d : msg->data) {
            total += d;
        }
        auto diff = rclcpp::Node::now() - this->last_time;
        RCLCPP_INFO(this->get_logger(), "I heard: '%i', %f",total, diff.seconds());
      this->last_time = rclcpp::Node::now();

      };
    subscription_ =
      this->create_subscription<sensor_msgs::msg::Image>("/camera/color/image_raw", 10, topic_callback);
  }

private:
  rclcpp::Subscription<sensor_msgs::msg::Image>::SharedPtr subscription_;
  rclcpp::Time last_time = rclcpp::Node::now();
};

int main(int argc, char * argv[])
{
  rclcpp::init(argc, argv);
  rclcpp::spin(std::make_shared<MinimalSubscriber>());
  rclcpp::shutdown();
  return 0;
}