#!/bin/bash
# set -xe

SCRIPT_DIR="/opt/ros/humble/share/mirte_zenoh_setup"
export PKG_HOME=$(realpath "$SCRIPT_DIR/")

# if MIRTE_ZENOH is set and it is not false, then use Zenoh
if [ -v MIRTE_ZENOH ] && [ "$MIRTE_ZENOH" != "false" ]; then
        echo "USING Zenoh"
        export RMW_IMPLEMENTATION=rmw_zenoh_cpp 

        # check that we can write to the PKG_HOME directory
        if [ ! -w "$PKG_HOME" ]; then
                # use a tmp directory
                export PKG_HOME=$(mktemp -d)
                # echo "WARNING: Cannot write to $SCRIPT_DIR, using $PKG_HOME instead"
                cp -r "$SCRIPT_DIR"/* "$PKG_HOME/"
        fi
        
        #   if MIRTE_ZENOH is true, then set router and ip vars
        if [ "$MIRTE_ZENOH" = "true" ]; then
                echo "MIRTE_ZENOH main robot mode"
                unset ZENOH_ROUTER_CONFIG_URI
                # export ZENOH_ROUTER_CONFIG_URI="$PKG_HOME/config/router_robot_config.json5"
                # export ZENOH_SESSION_CONFIG_URI="$PKG_HOME/config/session_config.json5"
        else
                echo "MIRTE_ZENOH client mode"
                # replace IP in config with $MIRTE_ZENOH
                sed "s/IP/\"tcp\/$MIRTE_ZENOH:7447\"/g" "$PKG_HOME/config/router_client_config.json5.in" > "$PKG_HOME/config/router_client_config.json5"
                export ZENOH_ROUTER_CONFIG_URI="$PKG_HOME/config/router_client_config.json5"
                # export ZENOH_SESSION_CONFIG_URI="$PKG_HOME/config/session_config.json5"
        fi

        # check if zenoh router is running on port 7447
        if [ -z "$(ss -l | grep -w "7447")" ]; then
                echo "Zenoh router is not running on port 7447"
                echo "Please run a Zenoh router on port 7447 with the following command:"
                echo "ros2 run rmw_zenoh_cpp rmw_zenohd"
        fi
elif [ "$MIRTE_ZENOH" != "false" ]; then # so it is not set
        # echo "Not using Zenoh, resetting all RMW variables once."
        # echo "To use MIRTE_ZENOH, set MIRTE_ZENOH to true on robot and to robot_ip/robot_hostname on other devices"
        # echo "To disable this message, set MIRTE_ZENOH to false"
        unset RMW_IMPLEMENTATION
        unset ZENOH_ROUTER_CONFIG_URI
        # unset ZENOH_SESSION_CONFIG_URI
        export MIRTE_ZENOH=false
# elif [ "$MIRTE_ZENOH" = "false" ]; then
#         unset RMW_IMPLEMENTATION
#         unset ZENOH_ROUTER_CONFIG_URI
#         unset ZENOH_SESSION_CONFIG_URI
fi

